/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.http.auth;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.TokenAuthentication;
import com.artipie.http.headers.Authorization;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TokenAuthScheme
implements AuthScheme {
    public static final String NAME = "token";
    private static final Pattern PTRN = Pattern.compile("/t/([^/]*)/.*");
    private final TokenAuthentication auth;

    public TokenAuthScheme(TokenAuthentication auth) {
        this.auth = auth;
    }

    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers, String line) {
        return this.user(headers, line).thenApply(user -> user.map(Success::new).orElse(new Failure()));
    }

    private CompletionStage<Optional<Authentication.User>> user(Iterable<Map.Entry<String, String>> headers, String line) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(Authorization::new).filter(hdr -> hdr.scheme().equals(NAME)).map(hdr -> new Authorization.Token(hdr.credentials()).token()).map(arg_0 -> ((TokenAuthentication)this.auth).user(arg_0)).orElseGet(() -> {
            Matcher mtchr = PTRN.matcher(new RequestLineFrom(line).uri().toString());
            CompletionStage res = CompletableFuture.completedFuture(Optional.empty());
            if (mtchr.matches()) {
                res = this.auth.user(mtchr.group(1));
            }
            return res;
        });
    }

    private static class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        public Optional<Authentication.User> user() {
            return Optional.empty();
        }

        public String challenge() {
            return TokenAuthScheme.NAME;
        }
    }

    private static class Success
    implements AuthScheme.Result {
        private final Authentication.User usr;

        Success(Authentication.User user) {
            this.usr = user;
        }

        public Optional<Authentication.User> user() {
            return Optional.of(this.usr);
        }

        public String challenge() {
            return TokenAuthScheme.NAME;
        }
    }
}

