/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.meta;

import com.artipie.ArtipieException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;

public interface InfoIndex {
    public static final String FILE_NAME = "info/index.json";

    public JsonObject json() throws IOException;

    public static final class Conda
    implements InfoIndex {
        private final InputStream input;

        public Conda(InputStream input) {
            this.input = input;
        }

        @Override
        public JsonObject json() throws IOException {
            Optional<Object> res = Optional.empty();
            try (ArchiveInputStream archive = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(this.input));){
                ArchiveEntry entry;
                while ((entry = archive.getNextEntry()) != null) {
                    String name;
                    if (!archive.canReadEntryData(entry) || entry.isDirectory() || !(name = entry.getName()).startsWith("info") || !name.endsWith("tar.zst")) continue;
                    TarArchiveInputStream info = new TarArchiveInputStream((InputStream)new ZstdCompressorInputStream((InputStream)archive));
                    while ((entry = info.getNextEntry()) != null) {
                        if (!info.canReadEntryData(entry) || entry.isDirectory() || !InfoIndex.FILE_NAME.equals(entry.getName())) continue;
                        res = Optional.of(Json.createReader((InputStream)info).readObject());
                    }
                }
            }
            catch (ArchiveException ex) {
                throw new IOException(ex);
            }
            return (JsonObject)res.orElseThrow(() -> new ArtipieException("Illegal package `.conda`: info/index.json file not found"));
        }
    }

    public static final class TarBz
    implements InfoIndex {
        private final InputStream input;

        public TarBz(InputStream input) {
            this.input = input;
        }

        @Override
        public JsonObject json() throws IOException {
            Optional<Object> res = Optional.empty();
            try (TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(this.input));){
                ArchiveEntry entry;
                while ((entry = archive.getNextEntry()) != null) {
                    if (!archive.canReadEntryData(entry) || entry.isDirectory() || !InfoIndex.FILE_NAME.equals(entry.getName())) continue;
                    res = Optional.of(Json.createReader((InputStream)archive).readObject());
                }
            }
            return (JsonObject)res.orElseThrow(() -> new ArtipieException("Illegal package .tar.bz2: info/index.json file not found"));
        }
    }
}

