/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda;

import com.artipie.asto.misc.UncheckedScalar;
import com.artipie.conda.AuthTokens;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public final class CachedAuthTokens
implements AuthTokens {
    private final Cache<String, AuthTokens.TokenItem> cache;
    private final AuthTokens origin;

    public CachedAuthTokens(Cache<String, AuthTokens.TokenItem> cache, AuthTokens origin) {
        this.cache = cache;
        this.origin = origin;
    }

    public CachedAuthTokens(AuthTokens origin) {
        this((Cache<String, AuthTokens.TokenItem>)CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).softValues().build(), origin);
    }

    @Override
    public CompletionStage<Optional<AuthTokens.TokenItem>> get(String token) {
        return this.checkAndCompute(Optional.ofNullable(this.cache.getIfPresent((Object)token)), () -> this.origin.get(token));
    }

    @Override
    public CompletionStage<Optional<AuthTokens.TokenItem>> find(String username) {
        return this.checkAndCompute(this.cache.asMap().values().stream().filter(item -> item.userName().equals(username)).findFirst(), () -> this.origin.find(username));
    }

    @Override
    public CompletionStage<AuthTokens.TokenItem> generate(String name, Duration ttl) {
        return this.origin.generate(name, ttl).thenApply(tkn -> {
            this.cache.put((Object)tkn.token(), tkn);
            return tkn;
        });
    }

    @Override
    public CompletionStage<Boolean> remove(String token) {
        return CompletableFuture.runAsync(() -> this.cache.invalidate((Object)token)).thenCompose(nothing -> this.origin.remove(token));
    }

    private CompletionStage<Optional<AuthTokens.TokenItem>> checkAndCompute(Optional<AuthTokens.TokenItem> item, Callable<CompletionStage<Optional<AuthTokens.TokenItem>>> compute) {
        CompletionStage<Optional<AuthTokens.TokenItem>> res = CompletableFuture.completedFuture(Optional.empty());
        if (!item.isPresent()) {
            res = ((CompletionStage)new UncheckedScalar(compute::call).value()).thenApply(tkn -> {
                tkn.ifPresent(present -> this.cache.put((Object)present.token(), present));
                return tkn;
            });
        } else if (!item.get().expired()) {
            res = CompletableFuture.completedFuture(item);
        }
        return res;
    }
}

