/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.misc.UncheckedIOScalar;
import com.artipie.conda.meta.InfoIndex;
import com.artipie.conda.meta.JsonMaid;
import com.artipie.conda.meta.MergedJson;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;

public interface CondaRepodata {

    public static final class PackageItem {
        private final InputStream input;
        private final String filename;
        private final String sha256;
        private final String md5;
        private final long size;

        public PackageItem(InputStream input, String filename, String sha256, String md5, long size) {
            this.input = input;
            this.filename = filename;
            this.sha256 = sha256;
            this.md5 = md5;
            this.size = size;
        }
    }

    public static final class Append {
        private final Optional<InputStream> input;
        private final OutputStream out;

        public Append(Optional<InputStream> input, OutputStream out) {
            this.input = input;
            this.out = out;
        }

        public Append(InputStream input, OutputStream out) {
            this(Optional.of(input), out);
        }

        public Append(OutputStream out) {
            this(Optional.empty(), out);
        }

        public void perform(List<PackageItem> packages) {
            HashMap<String, JsonObject> items = new HashMap<String, JsonObject>(packages.size());
            for (PackageItem pkg : packages) {
                InfoIndex mtd = pkg.filename.endsWith(".conda") ? new InfoIndex.Conda(pkg.input) : new InfoIndex.TarBz(pkg.input);
                items.put(pkg.filename, Json.createObjectBuilder((JsonObject)((JsonObject)new UncheckedIOScalar(mtd::json).value())).add("size", pkg.size).add("md5", pkg.md5).add("sha256", pkg.sha256).build());
            }
            JsonFactory factory = new JsonFactory();
            try {
                new MergedJson.Jackson(factory.createGenerator(this.out), this.input.map(new UncheckedIOFunc(arg_0 -> ((JsonFactory)factory).createParser(arg_0)))).merge(items);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }

    public static final class Remove {
        private final InputStream input;
        private final OutputStream out;

        public Remove(InputStream input, OutputStream out) {
            this.input = input;
            this.out = out;
        }

        public void perform(Set<String> checksums) {
            JsonFactory factory = new JsonFactory();
            try {
                new JsonMaid.Jackson(factory.createGenerator(this.out), factory.createParser(this.input)).clean(checksums);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }
}

