/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.conda.AuthTokens;
import com.artipie.conda.CachedAuthTokens;
import com.artipie.conda.asto.AstoAuthTokens;
import com.artipie.conda.http.AuthTypeSlice;
import com.artipie.conda.http.DeleteTokenSlice;
import com.artipie.conda.http.DownloadRepodataSlice;
import com.artipie.conda.http.GenerateTokenSlice;
import com.artipie.conda.http.GetPackageSlice;
import com.artipie.conda.http.GetUserSlice;
import com.artipie.conda.http.PostPackageReleaseSlice;
import com.artipie.conda.http.PostStageCommitSlice;
import com.artipie.conda.http.UpdateSlice;
import com.artipie.conda.http.auth.TokenAuth;
import com.artipie.conda.http.auth.TokenAuthScheme;
import com.artipie.conda.http.auth.TokenAuthSlice;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Action;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.BasicAuthSlice;
import com.artipie.http.auth.Permission;
import com.artipie.http.auth.Permissions;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.rt.ByMethodsRule;
import com.artipie.http.rt.RtPath;
import com.artipie.http.rt.RtRule;
import com.artipie.http.rt.RtRulePath;
import com.artipie.http.rt.SliceRoute;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.http.slice.SliceDownload;
import com.artipie.http.slice.SliceSimple;
import java.time.Duration;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CondaSlice
extends Slice.Wrap {
    private static final Pattern PTRN = Pattern.compile(".*/(.*/.*(\\.tar\\.bz2|\\.conda))$");

    public CondaSlice(Storage storage, String url) {
        this(storage, Permissions.FREE, Authentication.ANONYMOUS, AuthTokens.ANONYMOUS, url, Duration.ofDays(365L));
    }

    public CondaSlice(Storage storage, Permissions perms, Authentication users, String url, Duration ttl) {
        this(storage, perms, users, new CachedAuthTokens(new AstoAuthTokens(storage)), url, ttl);
    }

    private CondaSlice(Storage storage, Permissions perms, Authentication users, AuthTokens tokens, String url, Duration ttl) {
        super((Slice)new SliceRoute(new RtPath[]{new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath("/t/.*repodata\\.json$"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new TokenAuthSlice(new DownloadRepodataSlice(storage), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*repodata\\.json$"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new BasicAuthSlice((Slice)new DownloadRepodataSlice(storage), users, (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath("(/dist/|/t/).*(\\.tar\\.bz2|\\.conda)$"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new TokenAuthSlice((Slice)new SliceDownload(storage, CondaSlice.transform()), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*(\\.tar\\.bz2|\\.conda)$"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new BasicAuthSlice((Slice)new SliceDownload(storage, CondaSlice.transform()), users, (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath("/(stage|commit).*(\\.tar\\.bz2|\\.conda)$"), new ByMethodsRule(new RqMethod[]{RqMethod.POST})}), (Slice)new TokenAuthSlice(new PostStageCommitSlice(url), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*(\\.tar\\.bz2|\\.conda)$"), new ByMethodsRule(new RqMethod[]{RqMethod.POST})}), (Slice)new TokenAuthSlice(new UpdateSlice(storage), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*(package|release).*"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new TokenAuthSlice(new GetPackageSlice(), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*(package|release).*"), new ByMethodsRule(new RqMethod[]{RqMethod.POST})}), (Slice)new TokenAuthSlice(new PostPackageReleaseSlice(), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new ByMethodsRule(new RqMethod[]{RqMethod.HEAD}), (Slice)new SliceSimple((Response)StandardRs.OK)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath("/user"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new TokenAuthSlice(new GetUserSlice(new TokenAuthScheme(new TokenAuth(tokens))), (Permission)new Permission.ByName(perms, (Action)Action.Standard.READ), tokens)), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*authentication-type$"), new ByMethodsRule(new RqMethod[]{RqMethod.GET})}), (Slice)new AuthTypeSlice()), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*authentications$"), new ByMethodsRule(new RqMethod[]{RqMethod.POST})}), (Slice)new BasicAuthSlice((Slice)new GenerateTokenSlice(users, tokens, ttl), users, (Permission)new Permission.ByName(perms, (Action)Action.Standard.WRITE))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new RtRule.ByPath(".*authentications$"), new ByMethodsRule(new RqMethod[]{RqMethod.DELETE})}), (Slice)new BasicAuthSlice((Slice)new DeleteTokenSlice(tokens), users, (Permission)new Permission.ByName(perms, (Action)Action.Standard.WRITE))), new RtRulePath(RtRule.FALLBACK, (Slice)new SliceSimple((Response)StandardRs.NOT_FOUND))}));
    }

    private static Function<String, Key> transform() {
        return path -> {
            Matcher mtchr = PTRN.matcher((CharSequence)path);
            Object res = mtchr.matches() ? new Key.From(mtchr.group(1)) : new KeyFromPath(path);
            return res;
        };
    }
}

