/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.conda.meta;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonObject;

public interface MergedJson {
    public void merge(Map<String, JsonObject> var1) throws IOException;

    public static final class Jackson
    implements MergedJson {
        private static final String PACKAGES = "packages";
        private static final String TAR = ".tar.bz2";
        private static final String PACKAGES_CONDA = "packages.conda";
        private static final String CONDA = ".conda";
        private final JsonGenerator gnrt;
        private final Optional<JsonParser> parser;

        public Jackson(JsonGenerator gnrt, Optional<JsonParser> parser) {
            this.gnrt = gnrt;
            this.parser = parser;
        }

        @Override
        public void merge(Map<String, JsonObject> items) throws IOException {
            if (this.parser.isPresent()) {
                JsonToken token;
                JsonParser prsr = this.parser.get();
                AtomicReference<Boolean> tars = new AtomicReference<Boolean>(false);
                AtomicReference<Boolean> condas = new AtomicReference<Boolean>(false);
                while ((token = prsr.nextToken()) != null) {
                    if (token == JsonToken.END_OBJECT) {
                        token = prsr.nextToken();
                        if (token == null || token == JsonToken.END_OBJECT) continue;
                        this.gnrt.writeEndObject();
                        this.processJsonToken(items, prsr, token, tars, condas);
                        continue;
                    }
                    this.processJsonToken(items, prsr, token, tars, condas);
                }
                if (tars.get() ^ condas.get()) {
                    this.gnrt.writeEndObject();
                }
                if (!tars.get().booleanValue()) {
                    this.writePackagesItem(items, PACKAGES, TAR);
                }
                if (!condas.get().booleanValue()) {
                    this.writePackagesItem(items, PACKAGES_CONDA, CONDA);
                }
            } else {
                this.gnrt.writeStartObject();
                this.writePackagesItem(items, PACKAGES, TAR);
                this.writePackagesItem(items, PACKAGES_CONDA, CONDA);
            }
            this.gnrt.close();
        }

        private void processJsonToken(Map<String, JsonObject> items, JsonParser prsr, JsonToken token, AtomicReference<Boolean> tars, AtomicReference<Boolean> condas) throws IOException {
            if (token == JsonToken.FIELD_NAME && PACKAGES.equals(prsr.getCurrentName())) {
                this.appendNewPackages(items, prsr, TAR);
                tars.set(true);
            } else if (token == JsonToken.FIELD_NAME && PACKAGES_CONDA.equals(prsr.getCurrentName())) {
                this.appendNewPackages(items, prsr, CONDA);
                condas.set(true);
            } else if (token == JsonToken.FIELD_NAME && (prsr.getCurrentName().endsWith(TAR) || prsr.getCurrentName().endsWith(CONDA))) {
                String name = prsr.getCurrentName();
                prsr.nextToken();
                prsr.setCodec((ObjectCodec)new ObjectMapper());
                ObjectNode nodes = (ObjectNode)prsr.readValueAsTree();
                if (!items.containsKey(name)) {
                    this.gnrt.writeFieldName(name);
                    this.gnrt.setCodec((ObjectCodec)new ObjectMapper());
                    this.gnrt.writeTree((TreeNode)nodes);
                }
            } else {
                this.gnrt.copyCurrentEvent(prsr);
            }
        }

        private void writePackagesItem(Map<String, JsonObject> items, String name, String type) throws IOException {
            this.gnrt.writeFieldName(name);
            this.gnrt.writeStartObject();
            this.writeNewPackages(items, type);
            this.gnrt.writeEndObject();
        }

        private void appendNewPackages(Map<String, JsonObject> items, JsonParser prsr, String type) throws IOException {
            this.gnrt.copyCurrentEvent(prsr);
            prsr.nextToken();
            this.gnrt.copyCurrentEvent(prsr);
            this.writeNewPackages(items, type);
        }

        private void writeNewPackages(Map<String, JsonObject> items, String type) throws IOException {
            for (String pckg : items.keySet()) {
                if (!pckg.endsWith(type)) continue;
                this.gnrt.writeFieldName(pckg);
                this.gnrt.setCodec((ObjectCodec)new ObjectMapper());
                this.gnrt.writeTree((TreeNode)new ObjectMapper().readTree(items.get(pckg).toString()));
            }
        }
    }
}

