/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian;

import com.amihaiemil.eoyaml.YamlMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public interface Config {
    public String codename();

    public Collection<String> components();

    public Collection<String> archs();

    public static final class FromYaml
    implements Config {
        private final String name;
        private final YamlMapping yaml;

        public FromYaml(String name, Optional<YamlMapping> yaml) {
            this(name, yaml.orElseThrow(() -> new IllegalArgumentException("Illegal config: `setting` section is required for debian repos")));
        }

        public FromYaml(String name, YamlMapping yaml) {
            this.name = name;
            this.yaml = yaml;
        }

        @Override
        public String codename() {
            return this.name;
        }

        @Override
        public Collection<String> components() {
            return this.getValue("Components").orElseThrow(() -> new IllegalArgumentException("Illegal config: `Components` is required for debian repos"));
        }

        @Override
        public Collection<String> archs() {
            return this.getValue("Architectures").orElseThrow(() -> new IllegalArgumentException("Illegal config: `Architectures` is required for debian repos"));
        }

        private Optional<Collection<String>> getValue(String field) {
            return Optional.ofNullable(this.yaml.string(field)).map(val -> Arrays.asList(val.split(" ")));
        }
    }
}

