/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.debian.metadata.Release;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public interface Package {
    public CompletionStage<Void> add(String var1, Key var2);

    public static final class Asto
    implements Package {
        private final Storage asto;
        private final Release release;

        public Asto(Storage asto, Release release) {
            this.asto = asto;
            this.release = release;
        }

        @Override
        public CompletionStage<Void> add(String item, Key index) {
            byte[] bytes = item.getBytes(StandardCharsets.UTF_8);
            return ((CompletableFuture)((CompletableFuture)this.asto.exists(index).thenCompose(exists -> {
                CompletionStage<Object> res = exists != false ? ((CompletableFuture)this.asto.value(index).thenCompose(content -> new PublisherAs(content).bytes())).thenApply(buffer -> Asto.decompressAppendCompress(buffer, String.format("\n\n%s", item).getBytes(StandardCharsets.UTF_8))) : CompletableFuture.completedFuture(Asto.compress(bytes));
                return res;
            })).thenCompose(res -> this.asto.save(index, (Content)new Content.From(res)))).thenCompose(nothing -> this.release.update(index));
        }

        private static byte[] decompressAppendCompress(byte[] decompress, byte[] append) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream(decompress)));
                 GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(baos));){
                int cnt;
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    gcos.write(buf, 0, cnt);
                }
                gcos.write(append);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
            return baos.toByteArray();
        }

        private static byte[] compress(byte[] bytes) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(baos));){
                gcos.write(bytes);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
            return baos.toByteArray();
        }
    }
}

