/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface PackagesItem {
    public CompletionStage<String> format(String var1, Key var2);

    public static final class Asto
    implements PackagesItem {
        private final Storage asto;

        public Asto(Storage asto) {
            this.asto = asto;
        }

        @Override
        public CompletionStage<String> format(String control, Key deb) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.asto.value(deb).thenApply(val -> Asto.addSizeAndFilename((Long)val.size().orElseThrow(() -> new IllegalStateException("Content size unknown")), deb.string(), control))).thenCompose(res -> this.digests(deb, Digests.MD5).thenApply(hex -> Asto.addDigest(res, "MD5sum", hex)))).thenCompose(res -> this.digests(deb, Digests.SHA1).thenApply(hex -> Asto.addDigest(res, "SHA1", hex)))).thenCompose(res -> this.digests(deb, Digests.SHA256).thenApply(hex -> Asto.addDigest(res, "SHA256", hex)))).thenApply(Asto::sort);
        }

        private CompletionStage<String> digests(Key deb, Digests alg) {
            return this.asto.value(deb).thenCompose(val -> new ContentDigest(val, (Supplier)alg).hex());
        }

        private static String addDigest(String control, String alg, String hex) {
            return Stream.concat(Stream.of(control.split("\n")), Stream.of(String.format("%s: %s", alg, hex))).collect(Collectors.joining("\n"));
        }

        private static String addSizeAndFilename(long size, String filename, String control) {
            return Stream.concat(Stream.of(control.split("\n")), Stream.of(String.format("Filename: %s", filename), String.format("Size: %d", size))).collect(Collectors.joining("\n"));
        }

        private static String sort(String item) {
            String name = "Package";
            String res = item.startsWith("Package") ? item : Stream.of(item.split("\n")).sorted((one, two) -> {
                int sort = one.startsWith("Package") ? -1 : 1;
                return sort;
            }).collect(Collectors.joining("\n"));
            return res;
        }
    }
}

