/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.debian.Config;
import com.artipie.debian.misc.UnpackedContent;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;

public interface Release {
    public CompletionStage<Void> create();

    public CompletionStage<Void> update(Key var1);

    public Key key();

    public static final class Asto
    implements Release {
        private final Storage asto;
        private final Config config;

        public Asto(Storage asto, Config config) {
            this.asto = asto;
            this.config = config;
        }

        @Override
        public CompletionStage<Void> create() {
            return this.checksums().thenApply(checksums -> String.join((CharSequence)"\n", String.format("Codename: %s", this.config.codename()), String.format("Architectures: %s", String.join((CharSequence)" ", this.config.archs())), String.format("Components: %s", String.join((CharSequence)" ", this.config.components())), String.format("Date: %s", DateTimeFormatter.ofPattern("E, MMM dd yyyy HH:mm:ss Z").format(ZonedDateTime.now())), "SHA256:", checksums)).thenCompose(file -> this.asto.save(this.key(), (Content)new Content.From(file.getBytes(StandardCharsets.UTF_8))));
        }

        @Override
        public CompletionStage<Void> update(Key pckg) {
            String key = pckg.string().replace(this.subDir(), "");
            return this.packageData(pckg).thenCompose(pair -> this.asto.value(this.key()).thenCompose(content -> new PublisherAs(content).asciiString().thenApply(str -> Asto.addReplace(str, key, (String)pair.getLeft())).thenApply(str -> Asto.addReplace(str, key.replace(".gz", ""), (String)pair.getRight())))).thenCompose(str -> this.asto.save(this.key(), (Content)new Content.From(str.getBytes(StandardCharsets.UTF_8))));
        }

        @Override
        public Key key() {
            return new Key.From(String.format("dists/%s/Release", this.config.codename()));
        }

        private String subDir() {
            return String.format("dists/%s/", this.config.codename());
        }

        private CompletionStage<String> checksums() {
            RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
            return (CompletionStage)rxsto.list(Key.ROOT).flatMapObservable(Observable::fromIterable).filter(key -> key.string().endsWith("Packages.gz")).flatMapSingle(item -> SingleInterop.fromFuture(this.packageData((Key)item))).collect(StringBuilder::new, (builder, pair) -> builder.append((String)pair.getKey()).append("\n").append((String)pair.getValue()).append("\n")).map(StringBuilder::toString).to(SingleInterop.get());
        }

        private CompletionStage<Pair<String, String>> packageData(Key pkg) {
            String key = pkg.string().replace(this.subDir(), "");
            return ((CompletableFuture)this.asto.value(pkg).thenCompose(content -> new ContentDigest(content, (Supplier)Digests.SHA256).hex())).thenCompose(hex -> this.asto.value(pkg).thenCompose(content -> new UnpackedContent((Publisher<ByteBuffer>)content).sizeAndDigest().thenApply(data -> new ImmutablePair((Object)String.format(" %s %d %s", hex, content.size().orElseThrow(() -> new IllegalStateException("Content size unknown")), key), (Object)String.format(" %s %d %s", data.getValue(), data.getKey(), key.replace(".gz", ""))))));
        }

        private static String addReplace(String origin, String key, String repl) {
            String res = origin.contains(String.format("%s\n", key)) || origin.endsWith(key) ? origin.replaceAll(String.format(" .* %s(\n|$)", Pattern.quote(key)), String.format("%s\n", repl)) : String.format("%s\n%s", origin, repl);
            return res.replaceAll("\n+", "\n");
        }
    }
}

