/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.misc;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Remaining;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.concurrent.CompletionStage;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;

public final class UnpackedContent {
    private final Publisher<ByteBuffer> content;

    public UnpackedContent(Publisher<ByteBuffer> content) {
        this.content = content;
    }

    public CompletionStage<Pair<Long, String>> sizeAndDigest() {
        return (CompletionStage)new Concatenation(this.content).single().map(buf -> new Remaining(buf, true)).map(Remaining::bytes).map(bytes -> {
            ImmutablePair immutablePair;
            GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream((byte[])bytes)));
            try {
                int cnt;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                long size = 0L;
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    digest.update(buf, 0, cnt);
                    size += (long)cnt;
                }
                immutablePair = new ImmutablePair((Object)size, (Object)Hex.encodeHexString((byte[])digest.digest()));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        gcis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException err) {
                    throw new UncheckedIOException(err);
                }
            }
            gcis.close();
            return immutablePair;
        }).to(SingleInterop.get());
    }
}

