/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentAs;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.debian.Config;
import com.artipie.debian.metadata.Control;
import com.artipie.debian.metadata.InRelease;
import com.artipie.debian.metadata.Package;
import com.artipie.debian.metadata.PackagesItem;
import com.artipie.debian.metadata.Release;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;

public interface Debian {
    public CompletionStage<Void> updatePackages(List<Key> var1, Key var2);

    public CompletionStage<Key> updateRelease(Key var1);

    public CompletionStage<Key> generateRelease();

    public CompletionStage<Void> generateInRelease(Key var1);

    public static final class Asto
    implements Debian {
        private final Storage asto;
        private final Config config;

        public Asto(Storage asto, Config config) {
            this.asto = asto;
            this.config = config;
        }

        @Override
        public CompletionStage<Void> updatePackages(List<Key> debs, Key packages) {
            RxStorageWrapper bsto = new RxStorageWrapper(this.asto);
            return ((CompletionStage)Observable.fromIterable(debs).flatMapSingle(key -> ((Single)bsto.value(key).to((Function)ContentAs.BYTES)).map(bytes -> new Control.FromBinary((byte[])bytes).asString()).map(string -> new ImmutablePair(key, string))).flatMapSingle(pair -> Single.fromFuture(new PackagesItem.Asto(this.asto).format((String)pair.getValue(), (Key)pair.getKey()).toCompletableFuture())).collect(ArrayList::new, ArrayList::add).to(SingleInterop.get())).thenCompose(list -> new Package.Asto(this.asto).add((Iterable<String>)list, packages));
        }

        @Override
        public CompletionStage<Key> updateRelease(Key packages) {
            Release.Asto release = new Release.Asto(this.asto, this.config);
            return release.update(packages).thenApply(nothing -> release.key());
        }

        @Override
        public CompletionStage<Key> generateRelease() {
            Release.Asto release = new Release.Asto(this.asto, this.config);
            return release.create().thenApply(nothing -> release.key());
        }

        @Override
        public CompletionStage<Void> generateInRelease(Key release) {
            return new InRelease.Asto(this.asto, this.config).generate(release);
        }
    }
}

