/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;

public interface Control {
    public String asString();

    public static final class FromBinary
    implements Control {
        private static final String FILE_NAME = "control";
        private final byte[] pkg;

        public FromBinary(byte[] pkg) {
            this.pkg = pkg;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String asString() {
            try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream(this.pkg)));){
                ArchiveEntry entry;
                do {
                    if ((entry = input.getNextEntry()) == null) throw new IllegalStateException("Archive `control` is not found in the package");
                } while (!input.canReadEntryData(entry) || !entry.getName().startsWith(FILE_NAME));
                String string = FromBinary.unpackTar(FromBinary.stream(input, entry.getName()));
                return string;
            }
            catch (IOException | ArchiveException ex) {
                throw new IllegalStateException("Failed to obtain package metadata", ex);
            }
        }

        private static InputStream stream(ArchiveInputStream input, String name) throws IOException {
            GzipCompressorInputStream res;
            if (name.endsWith("gz")) {
                res = new GzipCompressorInputStream((InputStream)input);
            } else if (name.endsWith("xz")) {
                res = new XZCompressorInputStream((InputStream)input);
            } else {
                throw new IllegalStateException("Unsupported archive type");
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String unpackTar(InputStream input) throws IOException {
            try (TarArchiveInputStream tar = new TarArchiveInputStream(input);){
                TarArchiveEntry entry;
                while ((entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
                    if (!entry.isFile() || !entry.getName().equals(String.format("./%s", FILE_NAME))) continue;
                    String string = IOUtils.toString((InputStream)tar, (Charset)StandardCharsets.UTF_8);
                    return string;
                }
            }
            finally {
                input.close();
            }
            throw new IllegalStateException("File `control` is not found in `control` archive");
        }
    }
}

