/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.debian.Config;
import com.artipie.debian.GpgConfig;
import com.artipie.debian.misc.GpgClearsign;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface InRelease {
    public CompletionStage<Void> generate(Key var1);

    public Key key();

    public static final class Asto
    implements InRelease {
        private final Storage asto;
        private final Config config;

        public Asto(Storage asto, Config config) {
            this.asto = asto;
            this.config = config;
        }

        @Override
        public CompletionStage<Void> generate(Key release) {
            CompletionStage res;
            if (this.config.gpg().isPresent()) {
                GpgConfig gpg = this.config.gpg().get();
                res = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.asto.value(release).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenCompose(bytes -> gpg.key().thenApply(key -> new GpgClearsign((byte[])bytes).signedContent((byte[])key, gpg.password())))).thenCompose(bytes -> this.asto.save(this.key(), (Content)new Content.From(bytes)));
            } else {
                res = this.asto.value(release).thenCompose(content -> this.asto.save(this.key(), content));
            }
            return res;
        }

        @Override
        public Key key() {
            return new Key.From(new String[]{"dists", this.config.codename(), "InRelease"});
        }
    }
}

