/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Content;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.cactoos.list.ListOf;

public interface Package {
    public CompletionStage<Void> add(Iterable<String> var1, Key var2);

    public static final class Asto
    implements Package {
        private static final String SEP = "\n\n";
        private final Storage asto;

        public Asto(Storage asto) {
            this.asto = asto;
        }

        @Override
        public CompletionStage<Void> add(Iterable<String> items, Key index) {
            byte[] bytes = String.join((CharSequence)SEP, items).getBytes(StandardCharsets.UTF_8);
            return this.asto.exists(index).thenCompose(exists -> {
                CompletionStage res;
                if (exists.booleanValue()) {
                    try {
                        Path temp = Files.createTempDirectory("packages-", new FileAttribute[0]);
                        Path latest = Files.createTempFile(temp, "latest-", ".gz", new FileAttribute[0]);
                        res = ((CompletableFuture)((CompletableFuture)((CompletableFuture)new Copy(this.asto, (List)new ListOf((Object[])new Key[]{index})).copy((Storage)new FileStorage(temp)).thenAccept(nothing -> Asto.decompressAppendCompress(temp.resolve(index.string()), latest, bytes))).thenCompose(nothing -> new FileStorage(temp).move((Key)new Key.From(latest.getFileName().toString()), index))).thenCompose(nothing -> new Copy((Storage)new FileStorage(temp), (List)new ListOf((Object[])new Key[]{index})).copy(this.asto))).thenAccept(nothing -> FileUtils.deleteQuietly((File)temp.toFile()));
                    }
                    catch (IOException err) {
                        throw new IllegalStateException("Failed to create temp dir", err);
                    }
                } else {
                    res = this.asto.save(index, (Content)new Content.From(Asto.compress(bytes)));
                }
                return res;
            });
        }

        private static void decompressAppendCompress(Path decompress, Path res, byte[] append) {
            try (BufferedOutputStream baos = new BufferedOutputStream(Files.newOutputStream(res, new OpenOption[0]));
                 GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(decompress, new OpenOption[0])));
                 GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(baos));){
                int cnt;
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    gcos.write(buf, 0, cnt);
                }
                gcos.write(SEP.getBytes(StandardCharsets.UTF_8));
                gcos.write(append);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
        }

        private static byte[] compress(byte[] bytes) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(baos));){
                gcos.write(bytes);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
            return baos.toByteArray();
        }
    }
}

