/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.misc;

import com.jcabi.log.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public final class GpgClearsign {
    private final byte[] content;

    public GpgClearsign(byte[] content) {
        this.content = content;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] signedContent(byte[] key, String pass) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ArmoredOutputStream armored = new ArmoredOutputStream((OutputStream)out);
            try (BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(this.content));){
                byte[] byArray;
                try (ByteArrayOutputStream line = new ByteArrayOutputStream();){
                    PGPSignatureGenerator sgen = GpgClearsign.prepareGenerator(key, pass);
                    armored.beginClearText(8);
                    int ahead = GpgClearsign.readInputLine(line, input);
                    GpgClearsign.processLine((OutputStream)armored, sgen, line.toByteArray());
                    if (ahead != -1) {
                        do {
                            ahead = GpgClearsign.readInputLine(line, ahead, input);
                            sgen.update((byte)13);
                            sgen.update((byte)10);
                            GpgClearsign.processLine((OutputStream)armored, sgen, line.toByteArray());
                        } while (ahead != -1);
                    }
                    armored.endClearText();
                    BCPGOutputStream bout = new BCPGOutputStream((OutputStream)armored);
                    sgen.generate().encode((OutputStream)bout);
                    armored.close();
                    byArray = out.toByteArray();
                }
                return byArray;
            }
        }
        catch (PGPException err) {
            Logger.error((Object)this, (String)"Error while generating gpg-signature:\n%s", (Object[])new Object[]{err.getMessage()});
            throw new IllegalStateException(err);
        }
        catch (IOException err) {
            Logger.error((Object)this, (String)"IO error while generating gpg-signature:\n%s", (Object[])new Object[]{err.getMessage()});
            throw new UncheckedIOException(err);
        }
    }

    public byte[] signature(byte[] key, String pass) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armored = new ArmoredOutputStream((OutputStream)out);
        BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(this.content));
        try {
            int sym;
            armored.setHeader("Version", null);
            PGPSignatureGenerator sgen = GpgClearsign.prepareGenerator(key, pass);
            while ((sym = ((InputStream)input).read()) >= 0) {
                sgen.update((byte)sym);
            }
            BCPGOutputStream res = new BCPGOutputStream((OutputStream)armored);
            sgen.generate().encode((OutputStream)res);
            armored.close();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PGPException err) {
                Logger.error((Object)this, (String)"Error while generating gpg-signature:\n%s", (Object[])new Object[]{err.getMessage()});
                throw new IllegalStateException(err);
            }
            catch (IOException err) {
                Logger.error((Object)this, (String)"IO error while generating gpg-signature:\n%s", (Object[])new Object[]{err.getMessage()});
                throw new UncheckedIOException(err);
            }
        }
        ((InputStream)input).close();
        return byArray;
    }

    private static PGPSignatureGenerator prepareGenerator(byte[] key, String pass) throws IOException, PGPException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPSecretKey skey = GpgClearsign.readSecretKey(new ByteArrayInputStream(key));
        PGPPrivateKey pkey = skey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(pass.toCharArray()));
        PGPSignatureGenerator sgen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(skey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
        PGPSignatureSubpacketGenerator ssgen = new PGPSignatureSubpacketGenerator();
        sgen.init(1, pkey);
        Iterator ids = skey.getPublicKey().getUserIDs();
        if (ids.hasNext()) {
            ssgen.setSignerUserID(false, (String)ids.next());
            sgen.setHashedSubpackets(ssgen.generate());
        }
        return sgen;
    }

    private static PGPSecretKey readSecretKey(InputStream input) throws IOException, PGPException {
        Iterator keys = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator()).getKeyRings();
        while (keys.hasNext()) {
            Iterator skey = ((PGPSecretKeyRing)keys.next()).getSecretKeys();
            while (skey.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)skey.next();
                if (!key.isSigningKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    private static void processLine(OutputStream out, PGPSignatureGenerator sign, byte[] line) throws IOException {
        int length = GpgClearsign.getLengthWithoutWhiteSpace(line);
        if (length > 0) {
            sign.update(line, 0, length);
        }
        out.write(line, 0, line.length);
    }

    private static int getLengthWithoutWhiteSpace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && GpgClearsign.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isWhiteSpace(byte sym) {
        return GpgClearsign.isLineEnding(sym) || sym == 9 || sym == 32;
    }

    private static boolean isLineEnding(byte sym) {
        return sym == 13 || sym == 10;
    }

    private static int readInputLine(ByteArrayOutputStream out, InputStream input) throws IOException {
        int sym;
        out.reset();
        int ahead = -1;
        while ((sym = input.read()) >= 0) {
            out.write(sym);
            if (!GpgClearsign.isLineEnding((byte)sym)) continue;
            ahead = GpgClearsign.readPassedEol(out, sym, input);
            break;
        }
        return ahead;
    }

    private static int readInputLine(ByteArrayOutputStream out, int ahead, InputStream input) throws IOException {
        out.reset();
        int cnt = ahead;
        int res = ahead;
        do {
            out.write(cnt);
            if (cnt != 13 && cnt != 10) continue;
            res = GpgClearsign.readPassedEol(out, cnt, input);
            break;
        } while ((cnt = input.read()) >= 0);
        if (cnt < 0) {
            res = -1;
        }
        return res;
    }

    private static int readPassedEol(ByteArrayOutputStream out, int last, InputStream input) throws IOException {
        int ahead = input.read();
        if (last == 13 && ahead == 10) {
            out.write(ahead);
            ahead = input.read();
        }
        return ahead;
    }
}

