/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.misc;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Remaining;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.reactivestreams.Publisher;

public final class PublisherAsArchive {
    private final Publisher<ByteBuffer> content;

    public PublisherAsArchive(Publisher<ByteBuffer> content) {
        this.content = content;
    }

    public CompletionStage<byte[]> unpackedGz() {
        return (CompletionStage)new Concatenation(this.content).single().map(buf -> new Remaining(buf, true)).map(Remaining::bytes).map(bytes -> {
            byte[] byArray;
            GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream((byte[])bytes)));
            try {
                int cnt;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    out.write(buf, 0, cnt);
                }
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        gcis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException err) {
                    throw new UncheckedIOException(err);
                }
            }
            gcis.close();
            return byArray;
        }).to(SingleInterop.get());
    }
}

