/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.misc;

import com.artipie.asto.Content;
import com.artipie.asto.FailedCompletionStage;
import com.artipie.asto.Key;
import com.artipie.asto.fs.FileStorage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;

public final class UnpackedContent {
    private final Publisher<ByteBuffer> content;

    public UnpackedContent(Publisher<ByteBuffer> content) {
        this.content = content;
    }

    public CompletionStage<Pair<Long, String>> sizeAndDigest() {
        try {
            Path temp = Files.createTempDirectory("unpack-", new FileAttribute[0]);
            Path file = Files.createTempFile(temp, "Packages-", ".gz", new FileAttribute[0]);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return ((CompletableFuture)((CompletableFuture)new FileStorage(temp).save((Key)new Key.From(file.getFileName().toString()), (Content)new Content.From(this.content)).thenApply(ignored -> {
                ImmutablePair immutablePair;
                GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
                try {
                    int cnt;
                    long size = 0L;
                    byte[] buf = new byte[1024];
                    while (-1 != (cnt = gcis.read(buf))) {
                        digest.update(buf, 0, cnt);
                        size += (long)cnt;
                    }
                    immutablePair = new ImmutablePair((Object)size, (Object)Hex.encodeHexString((byte[])digest.digest()));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            gcis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException err) {
                        throw new UncheckedIOException(err);
                    }
                }
                gcis.close();
                return immutablePair;
            })).handle((pair, throwable) -> {
                FileUtils.deleteQuietly((File)temp.toFile());
                FailedCompletionStage res = throwable == null ? CompletableFuture.completedFuture(pair) : new FailedCompletionStage(throwable);
                return res;
            })).thenCompose(Function.identity());
        }
        catch (IOException err) {
            throw new UncheckedIOException(err);
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException(err);
        }
    }
}

