/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian;

import com.amihaiemil.eoyaml.YamlMapping;
import com.artipie.asto.Storage;
import com.artipie.debian.GpgConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public interface Config {
    public String codename();

    public Collection<String> components();

    public Collection<String> archs();

    public Optional<GpgConfig> gpg();

    public static final class FromYaml
    implements Config {
        private final String name;
        private final YamlMapping yaml;
        private final Storage storage;

        public FromYaml(String name, Optional<YamlMapping> yaml, Storage storage) {
            this(name, yaml.orElseThrow(() -> new IllegalArgumentException("Illegal config: `setting` section is required for debian repos")), storage);
        }

        public FromYaml(String name, YamlMapping yaml, Storage storage) {
            this.name = name;
            this.yaml = yaml;
            this.storage = storage;
        }

        @Override
        public String codename() {
            return this.name;
        }

        @Override
        public Collection<String> components() {
            return this.getValue("Components").orElseThrow(() -> new IllegalArgumentException("Illegal config: `Components` is required for debian repos"));
        }

        @Override
        public Collection<String> archs() {
            return this.getValue("Architectures").orElseThrow(() -> new IllegalArgumentException("Illegal config: `Architectures` is required for debian repos"));
        }

        @Override
        public Optional<GpgConfig> gpg() {
            Optional<GpgConfig> res = this.yaml.string("gpg_password") == null || this.yaml.string("gpg_secret_key") == null ? Optional.empty() : Optional.of(new GpgConfig.FromYaml(this.yaml, this.storage));
            return res;
        }

        private Optional<Collection<String>> getValue(String field) {
            return Optional.ofNullable(this.yaml.string(field)).map(val -> Arrays.asList(val.split(" ")));
        }
    }
}

