/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian;

import com.amihaiemil.eoyaml.YamlMapping;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.slice.KeyFromPath;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface GpgConfig {
    public String password();

    public CompletionStage<byte[]> key();

    public static final class FromYaml
    implements GpgConfig {
        static final String GPG_PASSWORD = "gpg_password";
        static final String GPG_SECRET_KEY = "gpg_secret_key";
        private final YamlMapping yaml;
        private final Storage storage;

        public FromYaml(Optional<YamlMapping> yaml, Storage storage) {
            this(yaml.orElseThrow(() -> new IllegalArgumentException("Illegal config: `setting` section is required for debian repos")), storage);
        }

        public FromYaml(YamlMapping yaml, Storage storage) {
            this.yaml = yaml;
            this.storage = storage;
        }

        @Override
        public String password() {
            return this.yaml.string(GPG_PASSWORD);
        }

        @Override
        public CompletionStage<byte[]> key() {
            return ((CompletableFuture)this.storage.value((Key)new KeyFromPath(this.yaml.string(GPG_SECRET_KEY))).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes);
        }
    }
}

