/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian;

import com.artipie.asto.ArtipieIOException;
import com.artipie.debian.metadata.ControlField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public interface MultiPackages {
    public void merge(Collection<InputStream> var1, OutputStream var2);

    public static final class Unique
    implements MultiPackages {
        @Override
        public void merge(Collection<InputStream> items, OutputStream res) {
            try {
                GZIPOutputStream gop = new GZIPOutputStream(res);
                HashSet<Pair<String, String>> packages = new HashSet<Pair<String, String>>(items.size());
                for (InputStream inp : items) {
                    Unique.appendPackages(gop, inp, packages);
                }
                gop.finish();
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }

        private static void appendPackages(OutputStream out, InputStream inp, Set<Pair<String, String>> packages) {
            try {
                String line;
                GZIPInputStream gis = new GZIPInputStream(inp);
                BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
                StringBuilder item = new StringBuilder();
                do {
                    if (((line = rdr.readLine()) == null || line.isEmpty()) && item.length() > 0) {
                        ImmutablePair pair = new ImmutablePair((Object)new ControlField.Package().value(item.toString()).get(0), (Object)new ControlField.Version().value(item.toString()).get(0));
                        if (!packages.contains(pair)) {
                            out.write(item.append('\n').toString().getBytes(StandardCharsets.UTF_8));
                            packages.add((Pair<String, String>)pair);
                        }
                        item = new StringBuilder();
                        continue;
                    }
                    if (line == null || line.isEmpty()) continue;
                    item.append(line).append('\n');
                } while (line != null);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }
}

