/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.http;

import com.artipie.asto.Storage;
import com.artipie.debian.Config;
import com.artipie.debian.metadata.InRelease;
import com.artipie.debian.metadata.Release;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class ReleaseSlice
implements Slice {
    private final Slice origin;
    private final Storage storage;
    private final Release release;
    private final InRelease inrelease;

    public ReleaseSlice(Slice origin, Storage asto, Release release, InRelease inrelease) {
        this.origin = origin;
        this.release = release;
        this.storage = asto;
        this.inrelease = inrelease;
    }

    public ReleaseSlice(Slice origin, Storage asto, Config config) {
        this(origin, asto, new Release.Asto(asto, config), new InRelease.Asto(asto, config));
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(this.storage.exists(this.release.key()).thenCompose(exists -> {
            CompletionStage<Response> res = exists != false ? CompletableFuture.completedFuture(this.origin.response(line, headers, body)) : this.release.create().thenCompose(nothing -> this.inrelease.generate(this.release.key())).thenApply(nothing -> this.origin.response(line, headers, body));
            return res;
        }));
    }
}

