/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;

public interface Control {
    public String asString();

    public static final class FromInputStream
    implements Control {
        private static final String FILE_NAME = "control";
        private final InputStream pkg;

        public FromInputStream(InputStream pkg) {
            this.pkg = pkg;
        }

        @Override
        public String asString() {
            Optional<Object> res = Optional.empty();
            try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(this.pkg));){
                ArchiveEntry entry;
                while ((entry = input.getNextEntry()) != null) {
                    if (!input.canReadEntryData(entry) || !entry.getName().startsWith(FILE_NAME)) continue;
                    res = Optional.of(FromInputStream.unpackTar(FromInputStream.stream(input, entry.getName())));
                }
            }
            catch (IOException | ArchiveException ex) {
                throw new IllegalStateException("Failed to obtain package metadata", ex);
            }
            return (String)res.orElseThrow(() -> new IllegalStateException("Archive `control` is not found in the package"));
        }

        private static InputStream stream(ArchiveInputStream input, String name) throws IOException {
            GzipCompressorInputStream res;
            if (name.endsWith("gz")) {
                res = new GzipCompressorInputStream((InputStream)input);
            } else if (name.endsWith("xz")) {
                res = new XZCompressorInputStream((InputStream)input);
            } else {
                throw new IllegalStateException("Unsupported archive type");
            }
            return res;
        }

        private static String unpackTar(InputStream input) throws IOException {
            TarArchiveEntry entry;
            TarArchiveInputStream tar = new TarArchiveInputStream(input);
            while ((entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
                if (!entry.isFile() || !entry.getName().equals(String.format("./%s", FILE_NAME))) continue;
                return IOUtils.toString((InputStream)tar, (Charset)StandardCharsets.UTF_8);
            }
            throw new IllegalStateException("File `control` is not found in `control` archive");
        }
    }
}

