/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;

public interface ControlField {
    public List<String> value(String var1);

    public static final class Filename
    extends ByName {
        public Filename() {
            super("Filename");
        }
    }

    public static final class Version
    extends ByName {
        public Version() {
            super("Version");
        }
    }

    public static final class Package
    extends ByName {
        public Package() {
            super("Package");
        }
    }

    public static final class Architecture
    extends ByName {
        public Architecture() {
            super("Architecture");
        }
    }

    public static abstract class ByName
    implements ControlField {
        private final String field;

        protected ByName(String field) {
            this.field = field;
        }

        @Override
        public List<String> value(String control) {
            return Stream.of(control.split("\n")).filter(item -> item.startsWith(this.field)).findFirst().map(item -> item.substring(item.indexOf(":") + 2)).map(res -> res.split(" ")).map(Arrays::asList).orElseThrow(() -> new NoSuchElementException(String.format("Field %s not found in control", this.field)));
        }
    }
}

