/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.StorageValuePipeline;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public interface Package {
    public CompletionStage<Void> add(Iterable<String> var1, Key var2);

    public static final class Asto
    implements Package {
        private static final String SEP = "\n\n";
        private final Storage asto;

        public Asto(Storage asto) {
            this.asto = asto;
        }

        @Override
        public CompletionStage<Void> add(Iterable<String> items, Key index) {
            return CompletableFuture.supplyAsync(() -> String.join((CharSequence)SEP, items).getBytes(StandardCharsets.UTF_8)).thenCompose(bytes -> new StorageValuePipeline(this.asto, index).process((opt, out) -> {
                if (opt.isPresent()) {
                    Asto.decompressAppendCompress((InputStream)opt.get(), out, bytes);
                } else {
                    Asto.compress(bytes, out);
                }
            }));
        }

        private static void decompressAppendCompress(InputStream decompress, OutputStream res, byte[] append) {
            try (BufferedOutputStream baos = new BufferedOutputStream(res);
                 GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)new BufferedInputStream(decompress));
                 GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(baos));){
                int cnt;
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    gcos.write(buf, 0, cnt);
                }
                gcos.write(SEP.getBytes(StandardCharsets.UTF_8));
                gcos.write(append);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
        }

        private static void compress(byte[] bytes, OutputStream res) {
            try (GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(res));){
                gcos.write(bytes);
            }
            catch (IOException err) {
                throw new UncheckedIOException(err);
            }
        }
    }
}

