/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.metadata;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.debian.metadata.ControlField;
import com.artipie.debian.metadata.Package;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class UniquePackage
implements Package {
    private static final String SEP = "\n\n";
    private final Storage asto;

    public UniquePackage(Storage asto) {
        this.asto = asto;
    }

    @Override
    public CompletionStage<Void> add(Iterable<String> items, Key index) {
        return new StorageValuePipeline(this.asto, index).processWithResult((opt, out) -> {
            List<Object> duplicates = Collections.emptyList();
            if (opt.isPresent()) {
                duplicates = UniquePackage.decompressAppendCompress((InputStream)opt.get(), out, items);
            } else {
                UniquePackage.compress(items, out);
            }
            return duplicates;
        }).thenCompose(this::remove);
    }

    private CompletionStage<Void> remove(List<String> keys) {
        return CompletableFuture.allOf((CompletableFuture[])keys.stream().map(Key.From::new).map(key -> this.asto.exists((Key)key).thenCompose(exists -> {
            CompletableFuture res = exists != false ? this.asto.delete((Key)key) : CompletableFuture.allOf(new CompletableFuture[0]);
            return res;
        })).toArray(CompletableFuture[]::new));
    }

    private static List<String> decompressAppendCompress(InputStream decompress, OutputStream res, Iterable<String> items) {
        byte[] bytes = String.join((CharSequence)SEP, items).getBytes(StandardCharsets.UTF_8);
        Set<Pair<String, String>> newbies = StreamSupport.stream(items.spliterator(), false).map(item -> new ImmutablePair((Object)new ControlField.Package().value((String)item).get(0), (Object)new ControlField.Version().value((String)item).get(0))).collect(Collectors.toSet());
        ArrayList<String> duplicates = new ArrayList<String>(5);
        try (GZIPInputStream gis = new GZIPInputStream(decompress);
             BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
             GZIPOutputStream gop = new GZIPOutputStream(new BufferedOutputStream(res));){
            String line;
            StringBuilder item2 = new StringBuilder();
            do {
                if (((line = rdr.readLine()) == null || line.isEmpty()) && item2.length() > 0) {
                    Optional<String> dupl = UniquePackage.duplicate(item2.toString(), newbies);
                    if (dupl.isPresent()) {
                        duplicates.add(dupl.get());
                    } else {
                        gop.write(item2.append('\n').toString().getBytes(StandardCharsets.UTF_8));
                    }
                    item2 = new StringBuilder();
                    continue;
                }
                if (line == null || line.isEmpty()) continue;
                item2.append(line).append('\n');
            } while (line != null);
            gop.write(bytes);
        }
        catch (UnsupportedEncodingException err) {
            throw new IllegalStateException(err);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return duplicates;
    }

    private static Optional<String> duplicate(String item, Set<Pair<String, String>> newbies) {
        ImmutablePair pair = new ImmutablePair((Object)new ControlField.Package().value(item).get(0), (Object)new ControlField.Version().value(item).get(0));
        Optional<String> res = Optional.empty();
        if (newbies.contains(pair)) {
            res = Optional.of(new ControlField.Filename().value(item).get(0));
        }
        return res;
    }

    private static void compress(Iterable<String> items, OutputStream res) {
        try (GzipCompressorOutputStream gcos = new GzipCompressorOutputStream(res);){
            gcos.write(String.join((CharSequence)SEP, items).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException err) {
            throw new UncheckedIOException(err);
        }
    }
}

