/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.debian.misc;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class SizeAndDigest
implements Function<InputStream, Pair<Long, String>> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<Long, String> apply(InputStream input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            long size = 0L;
            try (GzipCompressorInputStream gcis = new GzipCompressorInputStream(input);){
                int cnt;
                byte[] buf = new byte[1024];
                while (-1 != (cnt = gcis.read(buf))) {
                    digest.update(buf, 0, cnt);
                    size += (long)cnt;
                }
                ImmutablePair immutablePair = new ImmutablePair((Object)size, (Object)Hex.encodeHexString((byte[])digest.digest()));
                return immutablePair;
            }
        }
        catch (NoSuchAlgorithmException err) {
            throw new ArtipieException((Throwable)err);
        }
        catch (IOException err) {
            throw new ArtipieIOException(err);
        }
    }
}

