/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.Digests;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.RepoName;
import com.artipie.docker.asto.AstoBlob;
import com.artipie.docker.asto.BlobStore;
import com.artipie.docker.asto.BlobsLayout;
import com.artipie.docker.error.InvalidDigestException;
import io.reactivex.Flowable;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.cactoos.Bytes;
import org.cactoos.io.BytesOf;
import org.cactoos.text.HexOf;
import org.reactivestreams.Publisher;

public final class AstoBlobs
implements BlobStore {
    private final Storage asto;
    private final BlobsLayout layout;
    private final RepoName name;

    public AstoBlobs(Storage asto, BlobsLayout layout, RepoName name) {
        this.asto = asto;
        this.layout = layout;
        this.name = name;
    }

    @Override
    public CompletionStage<Optional<Blob>> blob(Digest digest) {
        Key key = this.layout.blob(this.name, digest);
        return this.asto.exists(key).thenApply(exists -> {
            Optional<Object> blob = exists != false ? Optional.of(new AstoBlob(this.asto, key, digest)) : Optional.empty();
            return blob;
        });
    }

    @Override
    public CompletionStage<Blob> put(Content blob, Digest digest) {
        MessageDigest sha = Digests.SHA256.get();
        Flowable checked = Flowable.fromPublisher((Publisher)blob).map(buf -> {
            sha.update(new Remaining(buf, true).bytes());
            return buf;
        }).doOnComplete(() -> {
            String calculated = new HexOf((Bytes)new BytesOf(sha.digest())).asString();
            String expected = digest.hex();
            if (!expected.equals(calculated)) {
                throw new InvalidDigestException(String.format("calculated: %s expected: %s", calculated, expected));
            }
        });
        Key key = this.layout.blob(this.name, digest);
        return ((CompletableFuture)this.asto.exists(key).thenCompose(arg_0 -> this.lambda$put$3(key, blob, (Publisher)checked, arg_0))).thenApply(nothing -> new AstoBlob(this.asto, key, digest));
    }

    private /* synthetic */ CompletionStage lambda$put$3(Key key, Content blob, Publisher checked, Boolean exists) {
        CompletableFuture result = exists != false ? CompletableFuture.allOf(new CompletableFuture[0]) : this.asto.save(key, (Content)new Content.From(blob.size(), checked));
        return result;
    }
}

