/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.docker.Digest;
import com.artipie.docker.Manifests;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.Tags;
import com.artipie.docker.asto.AstoTags;
import com.artipie.docker.asto.BlobStore;
import com.artipie.docker.asto.ManifestsLayout;
import com.artipie.docker.error.InvalidManifestException;
import com.artipie.docker.manifest.JsonManifest;
import com.artipie.docker.manifest.Layer;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.ref.ManifestRef;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.json.JsonException;

public final class AstoManifests
implements Manifests {
    private final Storage asto;
    private final BlobStore blobs;
    private final ManifestsLayout layout;
    private final RepoName name;

    public AstoManifests(Storage asto, BlobStore blobs, ManifestsLayout layout, RepoName name) {
        this.asto = asto;
        this.blobs = blobs;
        this.layout = layout;
        this.name = name;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        return new PublisherAs(content).bytes().thenCompose(bytes -> {
            Digest.Sha256 digest = new Digest.Sha256((byte[])bytes);
            return this.blobs.put((Content)new Content.From(bytes), digest).thenApply(blob -> new JsonManifest(digest, (byte[])bytes)).thenCompose(manifest -> this.validate((Manifest)manifest).thenCompose(nothing -> this.addManifestLinks(ref, digest)).thenApply(nothing -> manifest));
        });
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        return this.readLink(ref).thenCompose(digestOpt -> digestOpt.map(digest -> this.blobs.blob((Digest)digest).thenCompose(blobOpt -> blobOpt.map(blob -> blob.content().thenApply(PublisherAs::new).thenCompose(PublisherAs::bytes).thenApply(bytes -> new JsonManifest(blob.digest(), (byte[])bytes)).thenApply(Optional::of)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())));
    }

    @Override
    public CompletionStage<Tags> tags(Optional<Tag> from, int limit) {
        Key root = this.layout.tags(this.name);
        return this.asto.list(root).thenApply(keys -> new AstoTags(this.name, root, (Collection<Key>)keys, from, limit));
    }

    private CompletionStage<Void> validate(Manifest manifest) {
        Stream<Digest> digests;
        try {
            digests = Stream.concat(Stream.of(manifest.config()), manifest.layers().stream().filter(layer -> layer.urls().isEmpty()).map(Layer::digest));
        }
        catch (JsonException ex) {
            throw new InvalidManifestException(String.format("Failed to parse manifest: %s", ex.getMessage()), ex);
        }
        return CompletableFuture.allOf((CompletableFuture[])digests.map(digest -> this.blobs.blob((Digest)digest).thenCompose(opt -> {
            if (!opt.isPresent()) {
                throw new InvalidManifestException(String.format("Blob does not exist: %s", digest));
            }
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }).toCompletableFuture()).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> addManifestLinks(ManifestRef ref, Digest digest) {
        return CompletableFuture.allOf(this.addLink(new ManifestRef.FromDigest(digest), digest), this.addLink(ref, digest));
    }

    private CompletableFuture<Void> addLink(ManifestRef ref, Digest digest) {
        return this.asto.save(this.layout.manifest(this.name, ref), (Content)new Content.From(digest.string().getBytes(StandardCharsets.US_ASCII))).toCompletableFuture();
    }

    private CompletableFuture<Optional<Digest>> readLink(ManifestRef ref) {
        Key key = this.layout.manifest(this.name, ref);
        return this.asto.exists(key).thenCompose(exists -> {
            CompletionStage stage = exists != false ? ((CompletableFuture)((CompletableFuture)this.asto.value(key).thenCompose(pub -> new PublisherAs(pub).asciiString())).thenApply(Digest.FromString::new)).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return stage;
        });
    }
}

