/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.composite;

import com.artipie.docker.Catalog;
import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import com.artipie.docker.composite.MultiReadRepo;
import com.artipie.docker.misc.JoinedCatalogSource;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class MultiReadDocker
implements Docker {
    private final List<Docker> dockers;

    public MultiReadDocker(Docker ... dockers) {
        this(Arrays.asList(dockers));
    }

    public MultiReadDocker(List<Docker> dockers) {
        this.dockers = dockers;
    }

    @Override
    public Repo repo(RepoName name) {
        return new MultiReadRepo(name, this.dockers.stream().map(docker -> docker.repo(name)).collect(Collectors.toList()));
    }

    @Override
    public CompletionStage<Catalog> catalog(Optional<RepoName> from, int limit) {
        return new JoinedCatalogSource(this.dockers, from, limit).catalog();
    }
}

