/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.asto.Content;
import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.error.ManifestError;
import com.artipie.docker.http.DigestHeader;
import com.artipie.docker.http.ErrorsResponse;
import com.artipie.docker.http.Scope;
import com.artipie.docker.http.ScopeSlice;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.docker.ref.ManifestRef;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.ContentType;
import com.artipie.http.headers.Location;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class ManifestEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/manifests/(?<reference>.*)$");

    private ManifestEntity() {
    }

    static final class BaseResponse
    extends Response.Wrap {
        BaseResponse(Manifest mnf) {
            super((Response)new RsWithHeaders((Response)StandardRs.EMPTY, new Map.Entry[]{new ContentType(mnf.mediaType()), new DigestHeader(mnf.digest())}));
        }
    }

    static final class Request {
        private final RqByRegex rqregex;

        Request(String line) {
            this.rqregex = new RqByRegex(line, PATH);
        }

        RepoName name() {
            return new RepoName.Valid(this.rqregex.path().group("name"));
        }

        ManifestRef reference() {
            return new ManifestRef.FromString(this.rqregex.path().group("reference"));
        }
    }

    public static class Put
    implements ScopeSlice {
        private final Docker docker;

        Put(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Push(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(name).manifests().put(ref, (Content)new Content.From(body)).thenApply(manifest -> new RsWithHeaders((Response)new RsWithStatus(RsStatus.CREATED), new Map.Entry[]{new Location(String.format("/v2/%s/manifests/%s", name.value(), ref.string())), new ContentLength("0"), new DigestHeader(manifest.digest())})));
        }
    }

    public static class Get
    implements ScopeSlice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Pull(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            RepoName name = request.name();
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(name).manifests().get(ref).thenApply(manifest -> manifest.map(found -> {
                Manifest mnf = found.convert((Collection<String>)Head.acceptHeader(headers));
                return new RsWithBody((Response)new BaseResponse(mnf), mnf.content());
            }).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new ManifestError(ref)))));
        }
    }

    public static class Head
    implements ScopeSlice {
        private final Docker docker;

        Head(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Pull(new Request(line).name());
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Request request = new Request(line);
            ManifestRef ref = request.reference();
            return new AsyncResponse(this.docker.repo(request.name()).manifests().get(ref).thenApply(manifest -> manifest.map(found -> new BaseResponse(found.convert((Collection<String>)Head.acceptHeader(headers)))).orElseGet(() -> new ErrorsResponse(RsStatus.NOT_FOUND, new ManifestError(ref)))));
        }

        private static RqHeaders acceptHeader(Iterable<Map.Entry<String, String>> headers) {
            return new RqHeaders(headers, "Accept");
        }
    }
}

