/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.RepoName;

public interface Scope {
    public String type();

    public String name();

    public String action();

    default public String string() {
        return String.format("%s:%s:%s", this.type(), this.name(), this.action());
    }

    public static final class Registry
    implements Scope {
        private final String name;
        private final String action;

        public Registry(String name, String action) {
            this.name = name;
            this.action = action;
        }

        @Override
        public String type() {
            return "registry";
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String action() {
            return this.action;
        }
    }

    public static final class Repository
    implements Scope {
        private final RepoName name;
        private final String action;

        public Repository(RepoName name, String action) {
            this.name = name;
            this.action = action;
        }

        @Override
        public String type() {
            return "repository";
        }

        @Override
        public String name() {
            return this.name.value();
        }

        @Override
        public String action() {
            return this.action;
        }

        static final class Push
        extends Wrap {
            Push(RepoName name) {
                super(new Repository(name, "push"));
            }
        }

        static final class Pull
        extends Wrap {
            Pull(RepoName name) {
                super(new Repository(name, "pull"));
            }
        }
    }

    public static final class FromString
    implements Scope {
        private final String source;

        public FromString(String source) {
            this.source = source;
        }

        @Override
        public String type() {
            return this.part(0);
        }

        @Override
        public String name() {
            return this.part(1);
        }

        @Override
        public String action() {
            return this.part(2);
        }

        private String part(int index) {
            String[] tokens = this.source.split(":");
            if (tokens.length <= index) {
                throw new IllegalStateException(String.format("Source does not have part %d: %s", index, this.source));
            }
            return tokens[index];
        }
    }

    public static abstract class Wrap
    implements Scope {
        private final Scope scope;

        public Wrap(Scope scope) {
            this.scope = scope;
        }

        @Override
        public final String type() {
            return this.scope.type();
        }

        @Override
        public final String name() {
            return this.scope.name();
        }

        @Override
        public final String action() {
            return this.scope.action();
        }
    }
}

