/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.misc;

import com.artipie.asto.Content;
import com.artipie.docker.Digest;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletionStage;
import org.cactoos.Bytes;
import org.cactoos.io.BytesOf;
import org.cactoos.text.HexOf;
import org.reactivestreams.Publisher;

public final class DigestFromContent {
    private final Content content;

    public DigestFromContent(Content content) {
        this.content = content;
    }

    public CompletionStage<Digest> digest() {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException("This runtime doesn't have SHA-256 algorithm", err);
        }
        return ((CompletionStage)Flowable.fromPublisher((Publisher)this.content).flatMapCompletable(buf -> Completable.fromAction(() -> {
            buf.mark();
            sha.update((ByteBuffer)buf);
            buf.reset();
        })).andThen((SingleSource)Single.fromCallable(() -> new Digest.Sha256(new HexOf((Bytes)new BytesOf(sha.digest())).asString()))).to(SingleInterop.get())).toCompletableFuture();
    }
}

