/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.misc;

import com.artipie.docker.Manifests;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.Tags;
import com.artipie.docker.misc.ParsedTags;
import com.artipie.docker.misc.TagsPage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class JoinedTagsSource {
    private final RepoName repo;
    private final List<Manifests> manifests;
    private final Optional<Tag> from;
    private final int limit;

    public JoinedTagsSource(RepoName repo, Optional<Tag> from, int limit, Manifests ... manifests) {
        this(repo, Arrays.asList(manifests), from, limit);
    }

    public JoinedTagsSource(RepoName repo, List<Manifests> manifests, Optional<Tag> from, int limit) {
        this.repo = repo;
        this.manifests = manifests;
        this.from = from;
        this.limit = limit;
    }

    public CompletionStage<Tags> tags() {
        List<CompletableFuture> all = this.manifests.stream().map(mnfsts -> mnfsts.tags(this.from, this.limit).thenApply(ParsedTags::new).thenCompose(ParsedTags::tags).exceptionally(err -> Collections.emptyList())).collect(Collectors.toList());
        return ((CompletableFuture)CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).thenApply(nothing -> all.stream().flatMap(stage -> ((List)stage.toCompletableFuture().join()).stream()).collect(Collectors.toList()))).thenApply(names -> new TagsPage(this.repo, (Collection<Tag>)names, this.from, this.limit));
    }
}

