/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.ref;

import com.artipie.asto.Key;
import com.artipie.docker.Digest;
import com.artipie.docker.Tag;
import java.util.Arrays;

public interface ManifestRef {
    public Key link();

    public String string();

    public static final class FromString
    implements ManifestRef {
        private final String value;

        public FromString(String value) {
            this.value = value;
        }

        @Override
        public Key link() {
            ManifestRef ref;
            Digest.FromString digest = new Digest.FromString(this.value);
            Tag.Valid tag = new Tag.Valid(this.value);
            if (digest.valid()) {
                ref = new FromDigest(digest);
            } else if (tag.valid()) {
                ref = new FromTag(tag);
            } else {
                throw new IllegalStateException(String.format("Unsupported reference: `%s`", this.value));
            }
            return ref.link();
        }

        @Override
        public String string() {
            return this.value;
        }
    }

    public static final class FromTag
    implements ManifestRef {
        private final Tag tag;

        public FromTag(Tag tag) {
            this.tag = tag;
        }

        @Override
        public Key link() {
            return new Key.From(Arrays.asList("tags", this.tag.value(), "current", "link"));
        }

        @Override
        public String string() {
            return this.tag.value();
        }
    }

    public static final class FromDigest
    implements ManifestRef {
        private final Digest digest;

        public FromDigest(Digest digest) {
            this.digest = digest;
        }

        @Override
        public Key link() {
            return new Key.From(Arrays.asList("revisions", this.digest.alg(), this.digest.hex(), "link"));
        }

        @Override
        public String string() {
            return this.digest.string();
        }
    }
}

