/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.RepoName;
import com.artipie.docker.asto.AstoBlob;
import com.artipie.docker.asto.BlobSource;
import com.artipie.docker.asto.BlobStore;
import com.artipie.docker.asto.BlobsLayout;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public final class AstoBlobs
implements BlobStore {
    private final Storage asto;
    private final BlobsLayout layout;
    private final RepoName name;

    public AstoBlobs(Storage asto, BlobsLayout layout, RepoName name) {
        this.asto = asto;
        this.layout = layout;
        this.name = name;
    }

    @Override
    public CompletionStage<Optional<Blob>> blob(Digest digest) {
        Key key = this.layout.blob(this.name, digest);
        return this.asto.exists(key).thenApply(exists -> {
            Optional<Object> blob = exists != false ? Optional.of(new AstoBlob(this.asto, key, digest)) : Optional.empty();
            return blob;
        });
    }

    @Override
    public CompletionStage<Blob> put(BlobSource source) {
        Digest digest = source.digest();
        Key key = this.layout.blob(this.name, digest);
        return source.saveTo(this.asto, key).thenApply(nothing -> new AstoBlob(this.asto, key, digest));
    }
}

