/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Catalog;
import com.artipie.docker.Docker;
import com.artipie.docker.Repo;
import com.artipie.docker.RepoName;
import com.artipie.docker.asto.AstoCatalog;
import com.artipie.docker.asto.AstoRepo;
import com.artipie.docker.asto.DefaultLayout;
import com.artipie.docker.asto.Layout;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public final class AstoDocker
implements Docker {
    private final Storage asto;
    private final Layout layout;

    public AstoDocker(Storage asto) {
        this(asto, new DefaultLayout());
    }

    public AstoDocker(Storage asto, Layout layout) {
        this.asto = asto;
        this.layout = layout;
    }

    @Override
    public Repo repo(RepoName name) {
        return new AstoRepo(this.asto, this.layout, name);
    }

    @Override
    public CompletionStage<Catalog> catalog(Optional<RepoName> from, int limit) {
        Key root = this.layout.repositories();
        return this.asto.list(root).thenApply(keys -> new AstoCatalog(root, (Collection<Key>)keys, from, limit));
    }
}

