/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.Layers;
import com.artipie.docker.asto.BlobSource;
import com.artipie.docker.asto.BlobStore;
import com.artipie.docker.asto.TrustedBlobSource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public final class AstoLayers
implements Layers {
    private final BlobStore blobs;

    public AstoLayers(BlobStore blobs) {
        this.blobs = blobs;
    }

    @Override
    public CompletionStage<Blob> put(BlobSource source) {
        return this.blobs.put(source);
    }

    @Override
    public CompletionStage<Blob> mount(Blob blob) {
        return blob.content().thenCompose(content -> this.blobs.put(new TrustedBlobSource((Content)content, blob.digest())));
    }

    @Override
    public CompletionStage<Optional<Blob>> get(Digest digest) {
        return this.blobs.blob(digest);
    }
}

