/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.Tags;
import com.artipie.docker.asto.Children;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;

final class AstoTags
implements Tags {
    private final RepoName name;
    private final Key root;
    private final Collection<Key> keys;
    private final Optional<Tag> from;
    private final int limit;

    AstoTags(RepoName name, Key root, Collection<Key> keys, Optional<Tag> from, int limit) {
        this.name = name;
        this.root = root;
        this.keys = keys;
        this.from = from;
        this.limit = limit;
    }

    @Override
    public Content json() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        this.tags().stream().map(Tag::value).filter(tag -> this.from.map(last -> tag.compareTo(last.value()) > 0).orElse(true)).limit(this.limit).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return new Content.From(Json.createObjectBuilder().add("name", this.name.value()).add("tags", builder).build().toString().getBytes());
    }

    private Collection<Tag> tags() {
        return new Children(this.root, this.keys).names().stream().map(Tag.Valid::new).collect(Collectors.toList());
    }
}

