/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Storage;
import com.artipie.docker.RepoName;
import com.artipie.docker.Upload;
import com.artipie.docker.Uploads;
import com.artipie.docker.asto.AstoUpload;
import com.artipie.docker.asto.UploadsLayout;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class AstoUploads
implements Uploads {
    private final Storage asto;
    private final UploadsLayout layout;
    private final RepoName name;

    public AstoUploads(Storage asto, UploadsLayout layout, RepoName name) {
        this.asto = asto;
        this.layout = layout;
        this.name = name;
    }

    @Override
    public CompletionStage<Upload> start() {
        String uuid = UUID.randomUUID().toString();
        AstoUpload upload = new AstoUpload(this.asto, this.layout, this.name, uuid);
        return upload.start().thenApply(ignored -> upload);
    }

    @Override
    public CompletionStage<Optional<Upload>> get(String uuid) {
        CompletionStage<Optional<Upload>> result = uuid.isEmpty() ? CompletableFuture.completedFuture(Optional.empty()) : this.asto.list(this.layout.upload(this.name, uuid)).thenApply(list -> {
            Optional<Object> upload = list.isEmpty() ? Optional.empty() : Optional.of(new AstoUpload(this.asto, this.layout, this.name, uuid));
            return upload;
        });
        return result;
    }
}

