/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.http;

import com.artipie.docker.Docker;
import com.artipie.docker.RepoName;
import com.artipie.docker.Tag;
import com.artipie.docker.http.JsonContentType;
import com.artipie.docker.http.Scope;
import com.artipie.docker.http.ScopeSlice;
import com.artipie.docker.misc.RqByRegex;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqParams;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class TagsEntity {
    public static final Pattern PATH = Pattern.compile("^/v2/(?<name>.*)/tags/list$");

    private TagsEntity() {
    }

    public static class Get
    implements ScopeSlice {
        private final Docker docker;

        Get(Docker docker) {
            this.docker = docker;
        }

        @Override
        public Scope scope(String line) {
            return new Scope.Repository.Pull(Get.name(line));
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            RqParams params = new RqParams(new RequestLineFrom(line).uri().getQuery());
            return new AsyncResponse(this.docker.repo(Get.name(line)).manifests().tags(params.value("last").map(Tag.Valid::new), params.value("n").map(Integer::parseInt).orElse(Integer.MAX_VALUE)).thenApply(tags -> new RsWithBody((Response)new RsWithHeaders((Response)new RsWithStatus(RsStatus.OK), new Map.Entry[]{new JsonContentType()}), tags.json())));
        }

        private static RepoName.Valid name(String line) {
            return new RepoName.Valid(new RqByRegex(line, PATH).path().group("name"));
        }
    }
}

