/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.misc;

import com.artipie.asto.Remaining;
import com.artipie.asto.ext.Digests;
import com.artipie.docker.Digest;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.cactoos.Bytes;
import org.cactoos.io.BytesOf;
import org.cactoos.text.HexOf;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class DigestedFlowable
extends Flowable<ByteBuffer> {
    private final Publisher<ByteBuffer> origin;
    private final AtomicReference<Digest> dig = new AtomicReference();

    public DigestedFlowable(Publisher<ByteBuffer> origin) {
        this.origin = origin;
    }

    public void subscribeActual(Subscriber<? super ByteBuffer> subscriber) {
        MessageDigest sha = Digests.SHA256.get();
        Flowable.fromPublisher(this.origin).map(buf -> {
            sha.update(new Remaining(buf, true).bytes());
            return buf;
        }).doOnComplete(() -> this.dig.set(new Digest.Sha256(new HexOf((Bytes)new BytesOf(sha.digest())).asString()))).subscribe(subscriber);
    }

    public Digest digest() {
        return Objects.requireNonNull(this.dig.get(), "Digest is not yet calculated.");
    }
}

