/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.RepoName;
import com.artipie.docker.Upload;
import com.artipie.docker.Uploads;
import com.artipie.docker.asto.AstoUpload;
import com.artipie.docker.asto.UploadKey;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;

public final class AstoUploads
implements Uploads {
    private final Storage asto;
    private final RepoName name;

    public AstoUploads(Storage asto, RepoName name) {
        this.asto = asto;
        this.name = name;
    }

    @Override
    public CompletionStage<Upload> start() {
        String uuid = UUID.randomUUID().toString();
        AstoUpload upload = new AstoUpload(this.asto, this.name, uuid);
        return upload.start().thenApply(ignored -> upload);
    }

    @Override
    public CompletionStage<Optional<Upload>> get(String uuid) {
        return this.asto.list((Key)new UploadKey(this.name, uuid)).thenApply(list -> {
            Optional<Object> upload = list.isEmpty() ? Optional.empty() : Optional.of(new AstoUpload(this.asto, this.name, uuid));
            return upload;
        });
    }
}

