/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.manifest;

import com.artipie.asto.Content;
import com.artipie.docker.Digest;
import com.artipie.docker.manifest.Layer;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.misc.Json;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class JsonManifest
implements Manifest {
    private final Digest dgst;
    private final Content source;

    public JsonManifest(Digest dgst, Content source) {
        this.dgst = dgst;
        this.source = source;
    }

    @Override
    public CompletionStage<String> mediaType() {
        return this.json().thenApply(root -> root.getString("mediaType"));
    }

    @Override
    public CompletionStage<Manifest> convert(Collection<String> options) {
        return this.mediaType().thenApply(type -> {
            if (!options.contains(type)) {
                throw new IllegalArgumentException(String.format("Cannot convert from '%s' to any of '%s'", type, options));
            }
            return this;
        });
    }

    @Override
    public CompletionStage<Digest> config() {
        return this.json().thenApply(root -> new Digest.FromString(root.getJsonObject("config").getString("digest")));
    }

    @Override
    public CompletionStage<Collection<Layer>> layers() {
        return this.json().thenApply(root -> root.getJsonArray("layers").getValuesAs(JsonValue::asJsonObject).stream().map(x$0 -> new JsonLayer((JsonObject)x$0)).collect(Collectors.toList()));
    }

    @Override
    public Digest digest() {
        return this.dgst;
    }

    @Override
    public Content content() {
        return this.source;
    }

    private CompletionStage<JsonObject> json() {
        return new Json(this.source).object();
    }

    private static final class JsonLayer
    implements Layer {
        private final JsonObject json;

        private JsonLayer(JsonObject json) {
            this.json = json;
        }

        @Override
        public Digest digest() {
            return new Digest.FromString(this.json.getString("digest"));
        }

        @Override
        public Collection<URL> urls() {
            return Optional.ofNullable(this.json.getJsonArray("urls")).map(urls -> urls.getValuesAs(JsonString.class).stream().map(str -> {
                try {
                    return new URL(str.getString());
                }
                catch (MalformedURLException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        }
    }
}

