/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.proxy;

import com.artipie.asto.Content;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.RepoName;
import com.artipie.docker.proxy.BlobPath;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.ContentLength;
import io.reactivex.Flowable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class ProxyBlob
implements Blob {
    private final Slice remote;
    private final RepoName name;
    private final Digest dig;
    private final long bsize;

    public ProxyBlob(Slice remote, RepoName name, Digest dig, long size) {
        this.remote = remote;
        this.name = name;
        this.dig = dig;
        this.bsize = size;
    }

    @Override
    public Digest digest() {
        return this.dig;
    }

    @Override
    public CompletionStage<Long> size() {
        return CompletableFuture.completedFuture(this.bsize);
    }

    @Override
    public CompletionStage<Content> content() {
        CompletableFuture promise = new CompletableFuture();
        return this.remote.response(new RequestLine(RqMethod.GET.value(), new BlobPath(this.name, this.dig).string(), "HTTP/1.1").toString(), (Iterable)Headers.EMPTY, (Publisher)Flowable.empty()).send((status, headers, body) -> {
            long size = new ContentLength(headers).longValue();
            promise.complete(new Content.From(size, body));
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }).thenCompose(nothing -> promise);
    }
}

