/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.asto.AstoBlob;
import com.artipie.docker.asto.BlobKey;
import com.artipie.docker.asto.BlobStore;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

final class AstoBlobs
implements BlobStore {
    private final Storage asto;

    AstoBlobs(Storage asto) {
        this.asto = asto;
    }

    @Override
    public CompletionStage<Optional<Blob>> blob(Digest digest) {
        return this.asto.exists((Key)new BlobKey(digest)).thenApply(exists -> {
            Optional<Object> blob = exists != false ? Optional.of(new AstoBlob(this.asto, digest)) : Optional.empty();
            return blob;
        });
    }

    @Override
    public CompletionStage<Blob> put(Content blob, Digest digest) {
        return this.asto.save((Key)new BlobKey(digest), blob).thenApply(ignored -> new AstoBlob(this.asto, digest));
    }
}

