/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.docker.Digest;
import com.artipie.docker.Manifests;
import com.artipie.docker.RepoName;
import com.artipie.docker.asto.BlobStore;
import com.artipie.docker.asto.RegistryRoot;
import com.artipie.docker.manifest.JsonManifest;
import com.artipie.docker.manifest.Layer;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.misc.ByteBufPublisher;
import com.artipie.docker.ref.ManifestRef;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;

public final class AstoManifests
implements Manifests {
    private final Storage asto;
    private final BlobStore blobs;
    private final RepoName name;

    public AstoManifests(Storage asto, BlobStore blobs, RepoName name) {
        this.asto = asto;
        this.blobs = blobs;
        this.name = name;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        return new ByteBufPublisher(content).bytes().thenCompose(bytes -> {
            Digest.Sha256 digest = new Digest.Sha256((byte[])bytes);
            return this.blobs.put((Content)new Content.From(bytes), digest).thenApply(blob -> new JsonManifest(digest, (Content)new Content.From(bytes))).thenCompose(manifest -> this.validate((Manifest)manifest).thenCompose(nothing -> this.addManifestLinks(ref, digest)).thenApply(nothing -> manifest));
        });
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        return this.readLink(ref).thenCompose(digestOpt -> digestOpt.map(digest -> this.blobs.blob((Digest)digest).thenCompose(blobOpt -> blobOpt.map(blob -> blob.content().thenApply(ByteBufPublisher::new).thenCompose(ByteBufPublisher::bytes).thenApply(Content.From::new).thenApply(source -> new JsonManifest(blob.digest(), (Content)source)).thenApply(Optional::of)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())))).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty())));
    }

    private CompletionStage<Void> validate(Manifest manifest) {
        return manifest.config().thenCompose(config -> manifest.layers().thenApply(layers -> Stream.concat(Stream.of(config), layers.stream().filter(layer -> layer.urls().isEmpty()).map(Layer::digest)))).thenCompose(digests -> CompletableFuture.allOf((CompletableFuture[])digests.map(digest -> this.blobs.blob((Digest)digest).thenCompose(opt -> {
            if (opt.isEmpty()) {
                throw new IllegalArgumentException(String.format("Blob does not exist: %s", digest));
            }
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }).toCompletableFuture()).toArray(CompletableFuture[]::new)));
    }

    private CompletableFuture<Void> addManifestLinks(ManifestRef ref, Digest digest) {
        return CompletableFuture.allOf(this.addLink(new ManifestRef.FromDigest(digest), digest), this.addLink(ref, digest));
    }

    private CompletableFuture<Void> addLink(ManifestRef ref, Digest digest) {
        return this.asto.save(this.link(ref), (Content)new Content.From(digest.string().getBytes(StandardCharsets.US_ASCII))).toCompletableFuture();
    }

    private CompletableFuture<Optional<Digest>> readLink(ManifestRef ref) {
        Key key = this.link(ref);
        return this.asto.exists(key).thenCompose(exists -> {
            CompletionStage stage = exists != false ? ((CompletableFuture)((CompletableFuture)this.asto.value(key).thenCompose(pub -> new ByteBufPublisher((Content)pub).asciiString())).thenApply(Digest.FromString::new)).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return stage;
        });
    }

    private Key link(ManifestRef ref) {
        return new Key.From((Key)RegistryRoot.V2, new String[]{"repositories", this.name.value(), "_manifests", ref.link().string()});
    }
}

