/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker;

import java.util.regex.Pattern;

public interface RepoName {
    public String value();

    public static final class Simple
    implements RepoName {
        private final String name;

        public Simple(String name) {
            this.name = name;
        }

        @Override
        public String value() {
            return this.name;
        }
    }

    public static final class Valid
    implements RepoName {
        private static final Pattern PART_PTN = Pattern.compile("[a-z0-9]+(?:[._-][a-z0-9]+)*");
        private static final int MAX_NAME_LEN = 256;
        private final RepoName origin;

        public Valid(String name) {
            this(new Simple(name));
        }

        public Valid(RepoName origin) {
            this.origin = origin;
        }

        @Override
        public String value() {
            String src = this.origin.value();
            int len = src.length();
            if (len < 1 || len >= 256) {
                throw new IllegalStateException(String.format("repo name must be between 1 and %d chars long", 256));
            }
            if (src.charAt(len - 1) == '/') {
                throw new IllegalStateException("repo name can't end with a slash");
            }
            String[] parts = src.split("/");
            if (parts.length == 0) {
                throw new IllegalStateException("repo name can't be empty");
            }
            for (String part : parts) {
                if (PART_PTN.matcher(part).matches()) continue;
                throw new IllegalStateException(String.format("invalid repo name part: %s", part));
            }
            return src;
        }
    }
}

