/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.cache;

import com.artipie.asto.Content;
import com.artipie.docker.Blob;
import com.artipie.docker.Digest;
import com.artipie.docker.Manifests;
import com.artipie.docker.Repo;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.ref.ManifestRef;
import com.jcabi.log.Logger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class CacheManifests
implements Manifests {
    private final Repo origin;
    private final Repo cache;

    public CacheManifests(Repo origin, Repo cache) {
        this.origin = origin;
        this.cache = cache;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        return this.origin.manifests().get(ref).handle((original, throwable) -> {
            CompletionStage<Optional<Manifest>> result;
            if (throwable == null) {
                if (original.isPresent()) {
                    this.copy(ref);
                    result = CompletableFuture.completedFuture(original);
                } else {
                    result = this.cache.manifests().get(ref).exceptionally(ignored -> original);
                }
            } else {
                result = this.cache.manifests().get(ref);
            }
            return result;
        }).thenCompose(Function.identity());
    }

    private CompletionStage<Void> copy(ManifestRef ref) {
        return this.origin.manifests().get(ref).thenApply(Optional::get).thenCompose(manifest -> CompletableFuture.allOf(this.copy(manifest.config()).toCompletableFuture(), CompletableFuture.allOf((CompletableFuture[])manifest.layers().stream().filter(layer -> layer.urls().isEmpty()).map(layer -> this.copy(layer.digest()).toCompletableFuture()).toArray(CompletableFuture[]::new)).toCompletableFuture()).thenCompose(nothing -> this.cache.manifests().put(ref, manifest.content()))).handle((ignored, ex) -> {
            if (ex != null) {
                Logger.error((Object)this, (String)"Failed to cache manifest %s: %[exception]s", (Object[])new Object[]{ref.string(), ex});
            }
            return null;
        });
    }

    private CompletionStage<Void> copy(Digest digest) {
        return this.origin.layers().get(digest).thenCompose(blob -> {
            if (blob.isEmpty()) {
                throw new IllegalArgumentException(String.format("Failed loading blob %s", digest));
            }
            return ((Blob)blob.get()).content();
        }).thenCompose(content -> this.cache.layers().put((Content)content, digest)).thenCompose(blob -> CompletableFuture.allOf(new CompletableFuture[0]));
    }
}

