/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.docker.composite;

import com.artipie.asto.Content;
import com.artipie.docker.Manifests;
import com.artipie.docker.manifest.Manifest;
import com.artipie.docker.ref.ManifestRef;
import com.jcabi.log.Logger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MultiReadManifests
implements Manifests {
    private final List<Manifests> manifests;

    public MultiReadManifests(List<Manifests> manifests) {
        this.manifests = manifests;
    }

    @Override
    public CompletionStage<Manifest> put(ManifestRef ref, Content content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Optional<Manifest>> get(ManifestRef ref) {
        return MultiReadManifests.firstNotEmpty(this.manifests.stream().map(mnfsts -> mnfsts.get(ref).handle((manifest, throwable) -> {
            CompletableFuture<Optional> result;
            if (throwable == null) {
                result = CompletableFuture.completedFuture(manifest);
            } else {
                Logger.error((Object)this, (String)"Failed to read manifest %s: %[exception]s", (Object[])new Object[]{ref.string(), throwable});
                result = CompletableFuture.completedFuture(Optional.empty());
            }
            return result;
        }).thenCompose(Function.identity())).collect(Collectors.toList()));
    }

    private static <T> CompletionStage<Optional<T>> firstNotEmpty(List<CompletionStage<Optional<T>>> stages) {
        CompletableFuture<Optional<T>> promise = new CompletableFuture<Optional<T>>();
        CompletionStage<Void> preceeding = CompletableFuture.allOf(new CompletableFuture[0]);
        for (CompletionStage<Optional<Optional>> completionStage : stages) {
            preceeding = completionStage.thenCombine(preceeding, (opt, nothing) -> {
                if (opt.isPresent()) {
                    promise.complete((Optional)opt);
                }
                return nothing;
            });
        }
        preceeding.thenRun(() -> promise.complete(Optional.empty()));
        return promise;
    }
}

